'*************************************************************
'
' ADOBE SYSTEMS INCORPORATED
' Copyright 2005-2010 Adobe Systems Incorporated
' All Rights Reserved

' NOTICE:  Adobe permits you to use, modify, and
' distribute this file in accordance with the terms
' of the Adobe license agreement accompanying it.
' If you have received this file from a source
' other than Adobe, then your use, modification,
' or distribution of it requires the prior
' written permission of Adobe.
'
'*************************************************************

' SwatchGroupFromArt.vbs

' DESCRIPTION

' Create a new swatch group using colors in selected path item art.

' ************************************************************

Set appRef = CreateObject("Illustrator.Application")

' Check there is at least 1 document open
If appRef.Documents.Count > 0  Then
	Set docRef = appRef.ActiveDocument
	
	' Check there is a selection in the document
	If Not IsEmpty(appRef.Selection)  Then		
		' Add a new swatch group if it does not already exist
		Set swatchGroup = docRef.SwatchGroups(1)
		swatchGroupExists = false
		For Each swatchGroupRef In docRef.SwatchGroups	
			If swatchGroupRef.Name = "SwatchGroupFromArt" Then
				Set swatchGroup = swatchGroupRef
				swatchGroupExists = true
				Exit For	
			End If		
		Next
	
		If Not swatchGroupExists Then
			' Create new swatch group
			Set swatchGroup = docRef.SwatchGroups.Add
			swatchGroup.Name = "SwatchGroupFromArt"
		End If
		
		' Iterate through selected items		
		IterateSelection(appRef.Selection)
	Else
		' Must use JavaScript to display an alert
		appRef.DoJavaScript("alert(""Select some path art with colors applied before running this script"");")
	End If

Else
	' Must use JavaScript to display an alert
	appRef.DoJavaScript("alert(""Open a document containing some colored path art before running this script"");")
End If

Sub IterateSelection(selectedItems)
	' Get the fill color of each selected item
	For Each pathRef In selectedItems
	
		' Iterate path items within group items
		If TypeName(pathRef) = "GroupItem" Then
			IterateSelection(pathRef.PathItems)		
		ElseIf TypeName(pathRef) = "PathItem" Then
			' Do not continue if fill color is a gradient or a pattern
			If TypeName(pathRef.FillColor) <> "GradientColor" And TypeName(pathRef.FillColor) <> "PatternColor" Then
				' Iterate through existing swatches, checking if the color already exists in a swatch
				swatchExists = false
				For Each swatchRef In docRef.Swatches
					Set currentSwatchColor = swatchRef.Color
					If ColorEquals(pathRef.FillColor, currentSwatchColor) Then
						' Add the existing swatch to the swatch group
						swatchGroup.AddSwatch(swatchRef)
						swatchExists = true
						Exit For
					End If
				Next
				If swatchExists = false Then
					' Create a new swatch in the swatch group
					Set newSwatch = docRef.Swatches.Add
					newSwatch.Color = pathRef.FillColor
					swatchGroup.AddSwatch(newSwatch)
				End If
			End If
		End If
	Next
End Sub

Function ColorEquals(fillColor, swatchColor)
	ColorEquals = false					
	' Compare colors
	If TypeName(fillColor) = TypeName(swatchColor) Then
		Select Case TypeName(swatchColor)
			Case "CMYKColor"
				ColorEquals = CMYKColorEquals(fillColor, swatchColor)
			Case "RGBColor"
				ColorEquals= RGBColorEquals(fillColor, swatchColor)
			Case "GrayColor"
				ColorEquals = GrayColorEquals(fillColor, swatchColor)
			Case "LabColor"
				ColorEquals = LabColorEquals(fillColor, swatchColor)
			Case "SpotColor"
				ColorEquals = SpotColorEquals(fillColor, swatchColor)
			Case "NoColor"
			Case "PatternColor"
			Case "GradientColor"
			Case Else
		End Select
	End If
End Function

Function CMYKColorEquals(fillColor, swatchColor)
	CMYKColorEquals = false
	If fillColor.Cyan = swatchColor.Cyan And fillColor.Magenta = swatchColor.Magenta And fillColor.Yellow = swatchColor.Yellow And fillColor.Black = swatchColor.Black Then
		CMYKColorEquals = true
	End If
End Function

Function RGBColorEquals(fillColor, swatchColor)
	RGBColorEquals = false
	If fillColor.Red = swatchColor.Red And fillColor.Green = swatchColor.Green And fillColor.Blue = swatchColor.Blue Then
		RGBColorEquals = true
	End If
End Function

Function GrayColorEquals(fillColor, swatchColor)
	GrayColorEquals = false
	If fillColor.Gray = swatchColor.Gray Then
		GrayColorEquals = true
	End If
End Function

Function LabColorEquals(fillColor, swatchColor)
	LabColorEquals = false
	If fillColor.L = swatchColor.L And fillColor.A = swatchColor.A And fillColor.B = swatchColor.B Then
		LabColorEquals = true
	End If
End Function

Function SpotColorEquals(fillColor, swatchColor)
	SpotColorEquals = false
	Select Case TypeName(swatchColor.Spot.Color)
		Case "CMYKColor"
			SpotColorEquals = CMYKColorEquals(fillColor.Spot.Color, swatchColor.Spot.Color)
		Case "RGBColor"
			SpotColorEquals = RGBColorEquals(fillColor.Spot.Color, swatchColor.Spot.Color)
		Case "GrayColor"
			SpotColorEquals = GrayColorEquals(fillColor.Spot.Color, swatchColor.Spot.Color)
		Case "LabColor"
			SpotColorEquals = LabColorEquals(fillColor.Spot.Color, swatchColor.Spot.Color)
		Case Else
	End Select
End Function
'' SIG '' Begin signature block
'' SIG '' MIIY1QYJKoZIhvcNAQcCoIIYxjCCGMICAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFPiz0cSGXZj5
'' SIG '' bshekspjAzvgN614oIITuzCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFVjCCBD6gAwIBAgIQGRoyy3Wcl7jPrBGN
'' SIG '' 1RJ/STANBgkqhkiG9w0BAQsFADCByjELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYD
'' SIG '' VQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZv
'' SIG '' ciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
'' SIG '' ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENl
'' SIG '' cnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcNMTQw
'' SIG '' MzA0MDAwMDAwWhcNMjQwMzAzMjM1OTU5WjCBkTELMAkG
'' SIG '' A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
'' SIG '' cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
'' SIG '' ZXR3b3JrMUIwQAYDVQQDEzlTeW1hbnRlYyBDbGFzcyAz
'' SIG '' IEV4dGVuZGVkIFZhbGlkYXRpb24gQ29kZSBTaWduaW5n
'' SIG '' IENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
'' SIG '' ggEKAoIBAQDQGALu7aKNCFhjDybX3SJ7iPbkx+w7Jhh4
'' SIG '' 08ekIFONg3ylP36lyCtH3w31ptnDHSWTYM983OoDLL54
'' SIG '' f1xIbacC2Un4oevrmmF8n8Am1twV2LgQfCC6XvQo9qjq
'' SIG '' p1x8xpyQkDQ8tiKs/roMOh7WXoS2W/CjgXB4io1GUnv8
'' SIG '' 20nzKRMRdE+NFrPC46AtxwMEnczDcuEODPsCjvEmF3tu
'' SIG '' rvi3M4umYUtF3/IlRMf3sJgjNtwoeQrom3KIqNjornt/
'' SIG '' CmRFpfBXkpp3BkUe65/oZvN6fZKBXwAtHrj2VhNaYg23
'' SIG '' R6GPcu+DXoLglJjhrKWthjfgp9O6sT5660Wo8cFEfeID
'' SIG '' AgMBAAGjggFtMIIBaTASBgNVHRMBAf8ECDAGAQH/AgEA
'' SIG '' MC8GA1UdHwQoMCYwJKAioCCGHmh0dHA6Ly9zLnN5bWNi
'' SIG '' LmNvbS9wY2EzLWc1LmNybDAWBgNVHSUBAf8EDDAKBggr
'' SIG '' BgEFBQcDAzAOBgNVHQ8BAf8EBAMCAQYwLgYIKwYBBQUH
'' SIG '' AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
'' SIG '' ZC5jb20wXwYDVR0gBFgwVjBUBgRVHSAAMEwwIwYIKwYB
'' SIG '' BQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUG
'' SIG '' CCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20v
'' SIG '' cnBhMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1h
'' SIG '' bnRlY1BLSS0xLTYyOTAdBgNVHQ4EFgQUFmbeSjTjUKcR
'' SIG '' hgOxbKnGrM1ZbpswHwYDVR0jBBgwFoAUf9Nlp8Ld7Lvw
'' SIG '' MAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBAD9b
'' SIG '' GfP6E9V1OCpa7p9aoEypHcXMlO7eFf71EG6kG6Vkg1QY
'' SIG '' WMQLKKGFw0505f+JfP7V7Ty6cZ9WAiaPFiqI/rCjJyLO
'' SIG '' S+I4jgCmOoZfneU+qN5kSUF0QSH9B8iEF9odZTCCyyZP
'' SIG '' OdYEJ6SBsUtJwyOLfgIyGCe3qwvzGHK2pO5nBm84pliN
'' SIG '' 4PF+XaRgxqjlUF/g6Lrij5lYtrWgqHbxovEciEFyflKX
'' SIG '' mwo2mY1Q9wHrPOfwImrlNYxjNooasdlnZl+XGu+oIJ3w
'' SIG '' L7psztmUhQDxWPF9yXwitQddAsbmC7+rk5P/JxiOMzZ+
'' SIG '' VzTxw68EwYTxVrPoh4M2+NMKMdxuLG0wggXEMIIErKAD
'' SIG '' AgECAhAeObM6nEaakCI61S77g784MA0GCSqGSIb3DQEB
'' SIG '' CwUAMIGRMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3lt
'' SIG '' YW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFu
'' SIG '' dGVjIFRydXN0IE5ldHdvcmsxQjBABgNVBAMTOVN5bWFu
'' SIG '' dGVjIENsYXNzIDMgRXh0ZW5kZWQgVmFsaWRhdGlvbiBD
'' SIG '' b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNTExMDYwMDAw
'' SIG '' MDBaFw0xNzEwMjgyMzU5NTlaMIIBDjETMBEGCysGAQQB
'' SIG '' gjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECFAhEZWxh
'' SIG '' d2FyZTEdMBsGA1UEDxMUUHJpdmF0ZSBPcmdhbml6YXRp
'' SIG '' b24xEDAOBgNVBAUTBzI3NDgxMjkxCzAJBgNVBAYTAlVT
'' SIG '' MRMwEQYDVQQIDApDYWxpZm9ybmlhMREwDwYDVQQHDAhT
'' SIG '' YW4gSm9zZTEjMCEGA1UECgwaQWRvYmUgU3lzdGVtcyBJ
'' SIG '' bmNvcnBvcmF0ZWQxLDAqBgNVBAsMI0lsbHVzdHJhdG9y
'' SIG '' LCBJbkRlc2lnbiwgSW5Db3B5LCBNdXNlMSMwIQYDVQQD
'' SIG '' FBpBZG9iZSBTeXN0ZW1zIEluY29ycG9yYXRlZDCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJpOMyAj
'' SIG '' 8r+7FuNs3MXed0OMajoJnoF4v8cV+9drUVII+pzb6yeV
'' SIG '' GdBTt8U03rk1a2V51gcTHAorQxs2plJIgafn/pqMzG7f
'' SIG '' 9FZui7WiMOuyif/0joytDGujeQd7xQ/23YYtZpQQ/ahz
'' SIG '' VI4Pzv44FVDGwHYfGxGaQ127Bqp5EhLX7zwFiGEPnP3V
'' SIG '' R4ZyQn2WQeA0a68KuhD6anNHize0XjSBFelrNhN4uYpk
'' SIG '' prXyGv8vKdq9a911iY/efPsRueUPYucYJCF/lBt3DaR4
'' SIG '' J/FeaSJeijyllNwAqu7XY7Jl9zB0duRLlRFpGJeCymhY
'' SIG '' 3wvU6039CHBnrYIXZ/ldAWUpz+MCAwEAAaOCAZYwggGS
'' SIG '' MC4GA1UdEQQnMCWgIwYIKwYBBQUHCAOgFzAVDBNVUy1E
'' SIG '' RUxBV0FSRS0yNzQ4MTI5MAkGA1UdEwQCMAAwKwYDVR0f
'' SIG '' BCQwIjAgoB6gHIYaaHR0cDovL3N3LnN5bWNiLmNvbS9z
'' SIG '' dy5jcmwwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwMwDgYD
'' SIG '' VR0PAQH/BAQDAgeAMGYGA1UdIARfMF0wWwYLYIZIAYb4
'' SIG '' RQEHFwYwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5
'' SIG '' bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6
'' SIG '' Ly9kLnN5bWNiLmNvbS9ycGEwHQYDVR0OBBYEFPsxU7iZ
'' SIG '' MQ82sRMZZ9wcUZpCtgBaMFgGCCsGAQUFBwEBBEwwSjAf
'' SIG '' BggrBgEFBQcwAYYTaHR0cDovL3N3LnN5bWNkLmNvbTAn
'' SIG '' BggrBgEFBQcwAoYbaHR0cDovL3N3MS5zeW1jYi5jb20v
'' SIG '' c3cuY3J0MB8GA1UdIwQYMBaAFBZm3ko041CnEYYDsWyp
'' SIG '' xqzNWW6bMA0GCSqGSIb3DQEBCwUAA4IBAQBQEAjwXAas
'' SIG '' FygBRU/4fmAgJdTZDZFT/Gri5Vi28b6iHzDnTKcr3QTJ
'' SIG '' 33Ql9LbIi2CjtnD1n0zyvIdjXDXFLcbeMoQQ9L5XuiRw
'' SIG '' kwUPpRrLYsNPQ8G3n7N/me223Sw4noAy0ErrUNZd4Bew
'' SIG '' mTc3hn/95O1LC9QuGNFv/l+RyyFXBe3iJvHOpMBwIkMa
'' SIG '' OXB5/2FbFLqqELV4zWE2GXHhxfgxTgHHww1pJNBdPpxR
'' SIG '' qIjQxmgkL24azZZyxxtRWI6mpgCu+/4ZeXzwKSMycBYc
'' SIG '' gVG9c5TUSh+s1a4HPrrBJ1lPJQ+8+v3rc6ytjZXAC/g8
'' SIG '' GhhIrxvatjLMNWzrFNG7iEciMYIEhjCCBIICAQEwgaYw
'' SIG '' gZExCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
'' SIG '' YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMg
'' SIG '' VHJ1c3QgTmV0d29yazFCMEAGA1UEAxM5U3ltYW50ZWMg
'' SIG '' Q2xhc3MgMyBFeHRlbmRlZCBWYWxpZGF0aW9uIENvZGUg
'' SIG '' U2lnbmluZyBDQSAtIEcyAhAeObM6nEaakCI61S77g784
'' SIG '' MAkGBSsOAwIaBQCggaYwGQYJKoZIhvcNAQkDMQwGCisG
'' SIG '' AQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
'' SIG '' gjcCARUwIwYJKoZIhvcNAQkEMRYEFHzt8M8dCMbsgU/Z
'' SIG '' kNuL8V6Q9svfMEYGCisGAQQBgjcCAQwxODA2oDSAMgBB
'' SIG '' AGQAbwBiAGUAIABJAGwAbAB1AHMAdAByAGEAdABvAHIA
'' SIG '' IABDAEMAIAAyADAAMQA1MA0GCSqGSIb3DQEBAQUABIIB
'' SIG '' ABrVfHOcwQAW/9e2Z6WIHku/IAnkzXPH36WM/rm+AJ1z
'' SIG '' GWyL/nYtTDJbaqsNjypsrcBxbzY5/2id47ePg9x9znOt
'' SIG '' nY2NFnwQoMEKJyzuJQZfyfKCiQ0bX4NuI98sPZvE35/6
'' SIG '' 0KY+dwnUx+oUde7fdD5p2xo0lM+W4mmtlxYSEUCa8/UL
'' SIG '' cofEgqSsRt1meFFNebbawiHIsllGkGRkkaUoXxCjVTD1
'' SIG '' 42dFLUFB1asaIZsD/xsc3GlHHdNzBb3J+nXMBmo2hsZR
'' SIG '' Ua7X28T7f1llUhWdUJD9OFSkUJH2bSoexM07VROiRT+s
'' SIG '' /S02MhcSmEjlLA6E2CKIOKAsTgLpb+PbtSmhggILMIIC
'' SIG '' BwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQswCQYD
'' SIG '' VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
'' SIG '' YXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3Rh
'' SIG '' bXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVu
'' SIG '' BNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkD
'' SIG '' MQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTYw
'' SIG '' MTE0MjMxODQ4WjAjBgkqhkiG9w0BCQQxFgQU3iHyZgZd
'' SIG '' q5FmxorcfE9ZGM5WxyswDQYJKoZIhvcNAQEBBQAEggEA
'' SIG '' hQvBP59+iPCNCrCpTrAdBip6GEpXo6mpgh0zHy7kQQtO
'' SIG '' FtMdyE/2i5LmCR6EGZ4C91u6108wyhR8SkhMfIJIGYyP
'' SIG '' OS5kR/1XdhnWyyrCB4yBsFEWUFGctsK0nj/mWjxr6jP8
'' SIG '' jjfFq8n3OfCD3ura+/VoxFxD6yI5MKqWR5wg4RTP/Yne
'' SIG '' VRIUqB5S2eOrLJUQ2XhBdXSzEYuya9kpKDBNICejcQvn
'' SIG '' jXRp+hl/GXQ9DkvviOdrsxYg/s/fpa4uIqtdrIC+wkFS
'' SIG '' 8evFYm4U4+nfwLUBdcJI3yXKErxoctmpCW102WVtc4pG
'' SIG '' y8zh8xgTMgse3K/hFml24Rmip0ryYEiA+Q==
'' SIG '' End signature block
